//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) The Optional Enum
//:
//: ## Task:
//:
//: The Apple engineers who wrote Swift declared the `Optional` type using an enum with two cases; some and none.
//:
//: Below are three different implementations of Swifts `Optional` type. Delete the two that are not a direct match with how Apple created their `Optional` type.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


enum Optional1<T> {  // T means the `Type`. We're using Swift generics here
    case some(T) // associated value
    case none(T)
}

enum Optional2<T> {  // T means `Type`. We're using Swift generics
    case some
    case none(T) // associated value
}

enum Optional3<T> {  // T = Type
    case none
    case some(T) // associated value
}

// TODO: Delete two enums above and refactor the code below to work with the one chosen
let anOptionalInt: Optional1<Int> = .some(100)
if case Optional1.some(
    let unwrappedValue) = anOptionalInt {
    print(unwrappedValue)
} else {
    print("No value exists")
}

